<#ibiztemplate>
TARGET=PSDATAENTITY
</#ibiztemplate>
package ${pub.getPKGCodeName()}.${item.getPSSystemModule().codeName?lower_case}.service.dto;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import ${pub.getPKGCodeName()}.ibizutil.domain.ParentData;
import ${pub.getPKGCodeName()}.${item.getPSSystemModule().codeName?lower_case}.domain.${item.codeName};
import org.springframework.util.StringUtils;
import lombok.Data;
import java.util.Map;
import java.sql.Timestamp;
import ${pub.getPKGCodeName()}.ibizutil.service.SearchFilterBase;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonFormat;
import ${pub.getPKGCodeName()}.ibizutil.domain.DataObj;
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class ${item.getCodeName()}SearchFilter extends SearchFilterBase {

	private String query;
	private Page page;
	private QueryWrapper<${item.getCodeName()}> selectCond;
	public ${item.getCodeName()}SearchFilter(){
		this.page =new Page<${item.getCodeName()}>(1,Short.MAX_VALUE);
		this.selectCond=new QueryWrapper<${item.getCodeName()}>();	
	}
	/**
	 * 设定自定义查询条件，在原有SQL基础上追加该SQL
	 */
	public void setCustomCond(String sql)
	{
		this.selectCond.apply(sql);
	}
	/**
	 * 获取父数据
	 * @param srfparentdata
	 */
	public void setSrfparentdata(DataObj srfparentdata) {
		this.srfparentdata = srfparentdata;
		String strParentkey=this.getSrfparentdata().getStringValue("srfparentkey");
		<#comment>输出获取外键值方法-用于通过parentdata关系填充外键值id</#comment>
		<#list item.getPSDEFields() as defield>
		<#if defield.getAllPSDEFSearchModes()??>
		<#list defield.getAllPSDEFSearchModes() as formitem>
		<#if formitem.getPSDEField()??>
		<#assign defield=formitem.getPSDEField()>
		<#if defield.getDataType()=='PICKUP'>
		<#assign psder1n=defield.getPSDER1N().name>
		if(this.srfparentdata.containsKey("srfparentmode")&& this.getSrfparentdata().get("srfparentmode").equals("${psder1n}"))
			if(StringUtils.isEmpty(strParentkey)){
				this.set${formitem.name?lower_case?cap_first}("NA");
			}
			else{
				this.set${formitem.name?lower_case?cap_first}(strParentkey);
			}
		</#if>
		</#if>
		</#list>
		</#if>
		</#list> 
	}
	/**
	 * 启用快速搜索
	 */
	public void setQuery(String query)
	{
		 this.query=query;
		 if(!StringUtils.isEmpty(query)){
			<#list item.getPSDEFields() as defield>
				<#if defield.isEnableQuickSearch()==true>
			this.selectCond.or().like("${defield.name?lower_case}",query);
				</#if>
			</#list>
		 }
	}
	/**
	 * 输出实体搜索项
	 */
<#list item.getPSDEFields() as defield>
	<#if defield.getAllPSDEFSearchModes()??>
		<#list defield.getAllPSDEFSearchModes() as formitem>
			<#if formitem.getPSDEField()??>
				<#assign defDataType=formitem.getPSDEField().getDataType()>
				<#if defDataType == "DATETIME">
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
				<#elseif defDataType == "DATE">
    @JsonFormat(pattern="yyyy-MM-dd", timezone="GMT+8")
				<#elseif defDataType == "TIME">
    @JsonFormat(pattern="HH:mm", timezone="GMT+8")
				</#if>
	private ${srfjavatype(formitem.getPSDEField().stdDataType)} ${formitem.getName()?lower_case};//[${defield.getLogicName()}]
	public void set${formitem.getName()?lower_case?cap_first}(${srfjavatype(formitem.getPSDEField().stdDataType)} ${formitem.getName()?lower_case}) {
        this.${formitem.getName()?lower_case} = ${formitem.getName()?lower_case};
        if(!StringUtils.isEmpty(this.${formitem.getName()?lower_case})){
				<#if formitem.getValueOp() == "LIKE">
            this.selectCond.like("${formitem.getPSDEField().getName()?lower_case}", ${formitem.getName()?lower_case});
				<#elseif formitem.getValueOp() == "LEFTLIKE">
            this.selectCond.likeRight("${formitem.getPSDEField().getName()?lower_case}", ${formitem.getName()?lower_case});
				<#elseif formitem.getValueOp() == "RIGHTLIKE">
            this.selectCond.likeLeft("${formitem.getPSDEField().getName()?lower_case}", ${formitem.getName()?lower_case});
				<#elseif formitem.getValueOp() == "EQ">
            this.selectCond.eq("${formitem.getPSDEField().getName()?lower_case}", ${formitem.getName()?lower_case});
				<#elseif formitem.getValueOp() == "NOTEQ">
            this.selectCond.ne("${formitem.getPSDEField().getName()?lower_case}", ${formitem.getName()?lower_case});
				<#elseif formitem.getValueOp() == "GT">
            this.selectCond.gt("${formitem.getPSDEField().getName()?lower_case}", ${formitem.getName()?lower_case});
				<#elseif formitem.getValueOp() == "GTANDEQ">
            this.selectCond.ge("${formitem.getPSDEField().getName()?lower_case}", ${formitem.getName()?lower_case});
				<#elseif formitem.getValueOp() == "LT">
            this.selectCond.lt("${formitem.getPSDEField().getName()?lower_case}", ${formitem.getName()?lower_case});
				<#elseif formitem.getValueOp() == "LTANDEQ">
            this.selectCond.le("${formitem.getPSDEField().getName()?lower_case}", ${formitem.getName()?lower_case});
				<#elseif formitem.getValueOp() == "ISNOTNULL">
					<#if srfjavatype(formitem.getPSDEField().stdDataType)=='Integer'>
			if(this.${formitem.getName()?lower_case}==1){
				this.selectCond.isNotNull("${formitem.getPSDEField().getName()?lower_case}");
			}
					<#elseif srfjavatype(formitem.getPSDEField().stdDataType)=='String'>
			if(this.${formitem.getName()?lower_case}.equals("1")){
				this.selectCond.isNotNull("${formitem.getPSDEField().getName()?lower_case}");
			}
					</#if>
				<#elseif formitem.getValueOp() == "ISNULL">
					<#if srfjavatype(formitem.getPSDEField().stdDataType)=='Integer'>
			if(this.${formitem.getName()?lower_case}==1){
				this.selectCond.isNull("${formitem.getPSDEField().getName()?lower_case}");
			}
				<#elseif srfjavatype(formitem.getPSDEField().stdDataType)=='String'>
			if(this.${formitem.getName()?lower_case}.equals("1")){
				this.selectCond.isNull("${formitem.getPSDEField().getName()?lower_case}");
			}
					</#if>
				</#if>
        }
    }
			</#if>
		</#list>
	</#if>
</#list>

}